% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_effectiveness_crm.R
\name{effectiveness_crm}
\alias{effectiveness_crm}
\title{Computes the actual and predicted effectiveness of the collection of algorithms.}
\usage{
effectiveness_crm(mod)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}
}
\value{
A list with the following components:
\item{\code{effectivenessAUC}}{The area under the actual and predicted effectiveness curves. }
\item{\code{actcurves}}{The \code{x,y} coodinates for the actual  effectiveness curves for each algorithm. }
#' \item{\code{prdcurves}}{The \code{x,y} coodinates for the predicted  effectiveness curves for each algorithm. }
}
\description{
This function computes the actual and predicted effectiveness of the collection of algorithms for different tolerance values.
}
\examples{
set.seed(1)\donttest{
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
X <- cbind.data.frame(x1, x2, x3)
max_item <- rep(1,3)
min_item <- rep(0,3)
mod <- cirtmodel(X, max.item=max_item, min.item=min_item)
out <- effectiveness_crm(mod$model)
out
}
}
