% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apce.R
\name{APCEsummary}
\alias{APCEsummary}
\title{Summary of APCE}
\usage{
APCEsummary(apce.mcmc)
}
\arguments{
\item{apce.mcmc}{APCE.mcmc array generated from \code{CalAPCE} or \code{CalAPCEparallel}.}
}
\value{
A \code{data.frame} that consists of mean and quantiles (2.5%, 97.5%, 5%, 95%) of APCE (P(D(1)=d| R=r)-P(D(0)=d| R=r)) for each subgroup given specific value of D (decision) and R (principal strata).
}
\description{
Summary of average principal causal effects (APCE) with ordinal decision.
}
\examples{
\donttest{
data(synth)
sample_mcmc <- AiEvalmcmc(data = synth, n.mcmc = 10)
subgroup_synth <- list(
  1:nrow(synth), which(synth$Sex == 0), which(synth$Sex == 1),
  which(synth$Sex == 1 & synth$White == 0), which(synth$Sex == 1 & synth$White == 1)
)
sample_apce <- CalAPCE(data = synth, mcmc.re = sample_mcmc, subgroup = subgroup_synth)
sample_apce_summary <- APCEsummary(sample_apce[["APCE.mcmc"]])
}

}
\references{
Imai, K., Jiang, Z., Greiner, D.J., Halen, R., and Shin, S. (2023).
"Experimental evaluation of algorithm-assisted human decision-making:
application to pretrial public safety assessment."
Journal of the Royal Statistical Society: Series A.
<DOI:10.1093/jrsssa/qnad010>.
}
