% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{get_n_chunks}
\alias{get_n_chunks}
\title{Get the number of chunks/sequences for each case}
\usage{
get_n_chunks(text_embeddings, features, times)
}
\arguments{
\item{text_embeddings}{\code{data.frame} or \code{array} containing the text embeddings.}

\item{features}{\code{int} Number of features within each sequence.}

\item{times}{\code{int} Number of sequences}
}
\value{
Named\code{vector} of integers representing the number of chunks/sequences
for every case.
}
\description{
Function for calculating the number of chunks/sequences for every case
}
\examples{
test_array<-array(data=c(1,1,1,0,0,0,0,0,0,
                        2,1,1,2,5,6,0,0,0,
                        1,2,5,6,1,2,0,4,2),
                        dim=c(3,3,3))
test_array
#test array has shape (batch,times,features) with
#times=3 and features=3

#Slices where all values are zero are padded.

get_n_chunks(text_embeddings=test_array,features=3,times=3)
#The length of case 1 is 1, case 2 is 3, and case 3 is 2.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{clean_pytorch_log_transformers}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{is.null_or_na}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
