% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_disparity.R
\name{TestDisparity}
\alias{TestDisparity}
\title{Test assumption of disparities in sample size.}
\usage{
TestDisparity(n, study = NULL, coval = 0.1, plot = FALSE, color = "firebrick3")
}
\arguments{
\item{n}{NUMERIC values for sample size (n) of each study.}

\item{study}{STRINGS for study label of each study.}

\item{coval}{NUMERIC value of cutting-off value for variability that should be
smaller than zero.}

\item{plot}{LOGIC value for indicating whether to illustrate proportion of
excessive cases plot.}

\item{color}{STRING of a color name for emphasizing the significant
disparities in sample size.}
}
\value{
\strong{TestDisparity()} returns a summary of result regarding disparities in sample size.
}
\description{
\strong{TestDisparity()} is a function for disparities in sample size analysis.
}
\examples{
## Not run:
# 1. Import a dataset of study by Fleiss (1993)
library(meta)
data("Fleiss1993bin")
data <- Fleiss1993bin

# 2. Calculate total sample size and standard error of each study
data$n  <- data$n.asp + data$n.plac
data$se <- sqrt((1 / data$d.asp) - (1 / data$n.asp) + (1 / data$d.plac) - (1 / data$n.plac))

# 3. Test disparities in sample sizes
output <- TestDisparity(data$n, data$study)

# 4. Illustrate disparity plot
TestDisparity(data$n, data$study, plot = TRUE)

## End(Not run)

}
\references{
Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for
normality (complete samples). \strong{Biometrika}, \emph{52(3)}, 591-611.

Hendricks, W. A., & Robey, K. W. (1936). The sampling distribution of the
coefficient of variation. \strong{The Annals of Mathematical Statistics}, \emph{7(3)},
129-132.

Sokal, R. R., & Braumann, C. A. (1980). Significance tests for coefficients
of variation and variability profiles. \strong{Systematic Biology}, \emph{29(1)}, 50-66.
}
\seealso{
\code{\link{TestDiscordance}}
}
\author{
Enoch Kang
}
