% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_cr.R
\name{ahp.cr}
\alias{ahp.cr}
\title{Calculates the consistency ratio of each decision-maker}
\usage{
ahp.cr(ahpmat, atts)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{a list of attributes in the correct order. The RI is asymptotic as it approaches n=15, thus it is set to be equal to 1.6 if the number of attributes exceeds 16.}
}
\value{
A \code{list} of consistency ratios of each decision-maker.
}
\description{
The \code{ahp.cr} function calculates the consistency ratio of each decision-maker, defined by the following equation:

\deqn{CR = (\lambda-n)/((n-1)(RI))}

Where \eqn{\lambda} is the maximum eigenvalue of the pairwise comparison matrix, \eqn{n} is the number of attributes, and RI is the random index. Following \insertCite{Saaty2007fuzzy;textual}{ahpsurvey}, the RI is a function of \eqn{n} and is the consistency ratio of randomly generated pairwise comparison matrices.
}
\examples{

data(city200)
atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

cityahp <- ahp.mat(df = city200, atts = atts, negconvert = TRUE) 
ahp.cr(cityahp, atts)

}
\references{
\insertAllCited{}
}
\author{
Frankie Cho
}
