#' Dataframe of one decision-maker based on \insertCite{Saaty2004;textual}{ahpsurvey}
#'
#' A data.frame of one decision-maker with weights the same as \insertCite{Saaty2004;textual}{ahpsurvey}, with the pairwise comparisons of `atts`: `c('cult', 'fam', 'house', 'jobs', 'trans')`, about a choosing the best city to live in based on five attributes: Culture, Family, House, Jobs, and Transportation. Negative values in the data denote that the attribute on the left is more important than the right, thus if used with `ahp.mat`, `negconvert` must be set to `TRUE`.
#'
#' @docType data
#' @keywords datasets
#' @name city1
#' @usage data(city1)
#'
#' @format A data frame with 1 row and 10 variables, which are pairwise comparisons of `atts`.
#' @source \insertCite{Saaty2004;textual}{ahpsurvey}
"city1"


#' A dataframe of 200 simulated decision-makers based on \insertCite{Saaty2004;textual}{ahpsurvey}
#'
#' A data.frame of one decision-maker with weights the same as \insertCite{Saaty2004;textual}{ahpsurvey}, with the pairwise comparisons of `atts`: `c('cult', 'fam', 'house', 'jobs', 'trans')`, about a choosing the best city to live in based on five attributes: Culture, Family, House, Jobs, and Transportation. The choices of 200 decision-makers are simulated based on the underlying weights and randomness generated by a normal random distribution. The true weights are stored in `data(city1)`. The normal random distribution was set with a mean at the true weight value and a standard deviation of `2,1,2,1.5,2,1.5,2.5,0.5,0.5,1` in chronological order of the columns in `city200`.
#'
#' @docType data
#' @keywords datasets
#' @name city200
#' @usage data(city200)
#'
#' @format A `data.frame` with 200 row and 10 variables, which are pairwise comparisons of `atts`.
#' @source \insertAllCited{}
#'
"city200"
