\name{corsten.interaction}
\alias{corsten.interaction}
\docType{data}
\title{
  Multi-environment trial of corn
}
\description{
  The data is the yield (kg/acre) of 20 genotypes of corn at 7
  locations.
}

\format{
  A data frame with 140 observations on the following 3 variables.
  \describe{
    \item{\code{gen}}{genotype, 20 levels }
    \item{\code{loc}}{location, 7 levels }
    \item{\code{yield}}{yield, kg/acre}
  }
}
\details{
  The data is used by Corsten & Denis (1990) to illustrate two-way
  clustering by minimizing the interaction sum of squares.

  In their paper, the labels on the location dendrogram have a slight
  typo.  The order of the loc labels shown is 1 2 3 4 5 6 7.
  The correct order of the loc labels is 1 2 4 5 6 7 3.

  Used with permission of Jean-Baptiste Denis.
}
\source{
  L C A Corsten and J B Denis, (1990).
  Structuring Interaction in Two-Way Tables By Clustering.
  Biometrics, 46, 207--215. Table 1.
  http://doi.org/10.2307/2531644
}

\examples{
\dontrun{

library(agridat)
data(corsten.interaction)
dat <- corsten.interaction

libs(reshape2)
m1 <- melt(dat, measure.var='yield')
dmat <- acast(m1, loc~gen)

# Corsten (1990) uses this data to illustrate simultaneous row and
# column clustering based on interaction sums-of-squares.
# There is no (known) function in R to reproduce this analysis
# (please contact the package maintainer if this is not true).
# For comparison, the 'heatmap' function clusters the rows and
# columns _independently_ of each other.
heatmap(dmat, main="corsten.interaction")

}
}

