% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{compute_moment}
\alias{compute_moment}
\alias{compute_moment.default}
\alias{compute_moment.aghq}
\title{Compute moments}
\usage{
compute_moment(obj, ...)

\method{compute_moment}{default}(obj, ff = function(x) 1, ...)

\method{compute_moment}{aghq}(obj, ff = function(x) 1, ...)
}
\arguments{
\item{obj}{Object of class \code{aghq} output by \code{aghq::aghq()}, or its \code{normalized_posterior} element. See \code{?aghq}.}

\item{...}{Used to pass additional argument \code{ff}.}

\item{ff}{Any R function which takes in a numeric vector and returns a numeric vector.}
}
\value{
A numeric vector containing the moment(s) of ff with respect to the joint
distribution being approximated using AGHQ.
}
\description{
Compute the moment of any function ff using AGHQ.
}
\examples{
logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)
opt_sparsetrust_2d <- optimize_theta(funlist2d,c(1.5,1.5))
norm_sparse_2d_7 <- normalize_logpost(opt_sparsetrust_2d,7,1)

# ff = function(x) 1 should return 1,
# the normalizing constant of the (already normalized) posterior:
compute_moment(norm_sparse_2d_7)
# Compute the mean of theta1 and theta2
compute_moment(norm_sparse_2d_7,ff = function(x) x)
# Compute the mean of lambda1 = exp(theta1) and lambda2 = exp(theta2)
lambdameans <- compute_moment(norm_sparse_2d_7,ff = function(x) exp(x))
lambdameans
# Compare them to the truth:
(sum(y1) + 1)/(length(y1) + 1)
(sum(y2) + 1)/(length(y2) + 1)
# Compute the standard deviation of lambda1
lambda1sd <- sqrt(compute_moment(norm_sparse_2d_7,ff = function(x) (exp(x) - lambdameans[1])^2))[1]
# ...and so on.
}
\seealso{
Other summaries: 
\code{\link{compute_pdf_and_cdf}()},
\code{\link{compute_quantiles}()},
\code{\link{interpolate_marginal_posterior}()},
\code{\link{marginal_posterior}()}
}
\concept{summaries}
