% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize.R
\name{minimize}
\alias{minimize}
\title{Find optimal two-stage design by constraint minimization}
\usage{
minimize(
  objective,
  subject_to,
  initial_design,
  lower_boundary_design = get_lower_boundary_design(initial_design),
  upper_boundary_design = get_upper_boundary_design(initial_design),
  opts = list(algorithm = "NLOPT_LN_COBYLA", xtol_rel = 1e-05, maxeval = 10000),
  ...
)
}
\arguments{
\item{objective}{objective function}

\item{subject_to}{constraint collection}

\item{initial_design}{initial guess (x0 for nloptr)}

\item{lower_boundary_design}{design specifying the lower boundary.}

\item{upper_boundary_design}{design specifying the upper boundary}

\item{opts}{options list passed to nloptr}

\item{...}{further optional arguments passed to \code{\link{nloptr}}}
}
\value{
a list with elements:
\item{design}{ The resulting optimal design}
\item{nloptr_return}{ Output of the corresponding nloptr call}
\item{call_args}{ The arguments given to the optimization call}
}
\description{
\code{minimize} takes an unconditional score and
a constraint set (or no constraint) and solves the corresponding
minimization problem using
\href{https://cran.r-project.org/package=nloptr}{\code{nloptr}}
(using COBYLA by default).
An initial design has to be defined. It is also possible to define
lower- and upper-boundary designs. If this is not done, the boundaries are
determined automatically heuristically.
}
\examples{
# Define Type one error rate
toer <- Power(Normal(), PointMassPrior(0.0, 1))

# Define Power at delta = 0.4
pow <- Power(Normal(), PointMassPrior(0.4, 1))

# Define expected sample size at delta = 0.4
ess <- ExpectedSampleSize(Normal(), PointMassPrior(0.4, 1))

# Compute design minimizing ess subject to power and toer constraints
\donttest{
minimize(

   ess,

   subject_to(
      toer <= 0.025,
      pow  >= 0.9
   ),

   initial_design = TwoStageDesign(50, .0, 2.0, 60.0, 2.0, 5L)

)
}

}
