% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\docType{class}
\name{UnconditionalScore-class}
\alias{UnconditionalScore-class}
\alias{UnconditionalScore}
\title{Class for unconditional scoring function}
\description{
\code{UnconditionalScore} is an abstract class for unconditional scores.
}
\details{
When defining a new \code{UnconditionalScore}, a corresponding
method \code{\link{evaluate}} needs to be defined, too.
}
\examples{
design <- TwoStageDesign(
  n1    = 25,
  c1f   = 0,
  c1e   = 2.5,
  n2    = 50,
  c2    = 1.96,
  order = 7L
)

cp <- ConditionalPower(Normal(), PointMassPrior(.1, 1.0))
ep <- expected(cp)

evaluate(ep, design) # .06081054



}
\seealso{
There are regularization scores \code{\link{N1}} and
   \code{\link{AverageN2}} for sample sizes.
   The class \code{\link{IntegralScore}} is a specific subclass that defines
   uncondtional scores which are expected conditional scores.
}
