% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\name{remove_duplicates}
\alias{remove_duplicates}
\title{Remove duplicate graphs from a list.}
\usage{
remove_duplicates(graph_list, organise = FALSE, return_piles = FALSE)
}
\arguments{
\item{graph_list}{A list of graphs with the same leaf set.}

\item{organise}{If \code{TRUE} also organises isomorphic graphs (now disregarding leaf names)
next to each other.}

\item{return_piles}{If \code{TRUE} and \code{organise} is also \code{TRUE}, the output will be a
list of lists of isomorphic graphs instead of one big list.}
}
\value{
A list of graphs that are all different (or a list of lists of graphs if both \code{organise}
        and \code{return_piles} are \code{TRUE}).
}
\description{
Using \code{\link{canonise_graph}} to calculate unique characteristic logical vector for each
graph in a given list of graphs, then sorts the list according to this attribute and remove
repeated graphs.
Leaf names count so that graphs with permuted leaves are considered different.
Also organises similar graphs next to each other if \code{organise} is \code{TRUE}, but this
is extremely slow.
}

