% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{tte_source}
\alias{tte_source}
\title{Create a \code{tte_source} Object}
\usage{
tte_source(dataset_name, filter = NULL, date, censor = 0, set_values_to = NULL)
}
\arguments{
\item{dataset_name}{The name of the source dataset

The name refers to the dataset provided by the \code{source_datasets} parameter
of \code{derive_param_tte()}.}

\item{filter}{An unquoted condition for selecting the observations from
\code{dataset} which are events or possible censoring time points.}

\item{date}{A variable providing the date of the event or censoring. A date,
or a datetime can be specified. An unquoted symbol is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.}

\item{censor}{Censoring value

CDISC strongly recommends using \code{0} for events and positive integers for
censoring.}

\item{set_values_to}{A named list returned by \code{vars()} defining the variables
to be set for the event or censoring, e.g. \code{vars(EVENTDESC = "DEATH", SRCDOM = "ADSL", SRCVAR = "DTHDT")}. The values must be a symbol, a
character string, a numeric value, or \code{NA}.}
}
\value{
An object of class \code{tte_source}
}
\description{
The \code{tte_source} object is used to define events and possible censorings.
}
\seealso{
\code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=censor_source]{censor_source()}}, \code{\link[=event_source]{event_source()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_terms}()},
\code{\link{assert_valid_queries}()},
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\author{
Stefan Bundfuss
}
\concept{source_specifications}
\keyword{source_specifications}
