% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{lstalvdt_source}
\alias{lstalvdt_source}
\title{Create an \code{lstalvdt_source} object}
\usage{
lstalvdt_source(
  dataset_name,
  filter = NULL,
  date,
  date_imputation = NULL,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the last known alive date.}

\item{filter}{An unquoted condition for filtering \code{dataset}.}

\item{date}{A variable providing a date where the patient was known to be
alive. A date, a datetime, or a character variable containing ISO 8601
dates can be specified. An unquoted symbol is expected.}

\item{date_imputation}{A string defining the date imputation for \code{date}.
See \code{date_imputation} parameter of \code{impute_dtc()} for valid values.}

\item{traceability_vars}{A named list returned by \code{vars()} defining the
traceability variables, e.g. \code{vars(LALVDOM = "AE", LALVSEQ = AESEQ, LALVVAR = "AESTDTC")}. The values must be a symbol, a character string, or \code{NA}.}
}
\value{
An object of class \code{lstalvdt_source}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{Deprecated}, please use \code{date_source()} instead.
}
\author{
Stefan Bundfuss
}
\keyword{source_specifications}
