% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_list_of}
\alias{assert_list_of}
\title{Is an Argument a List of Objects of a Specific S3 Class?}
\usage{
assert_list_of(arg, class, optional = TRUE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{class}{The S3 class to check for}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a list or if \code{arg} is a list but its
elements are not objects inheriting from \code{class}. Otherwise, the input is returned
invisibly.
}
\description{
Checks if an argument is a \code{list} of objects inheriting from the S3 class specified.
}
\examples{
example_fun <- function(list) {
  assert_list_of(list, "data.frame")
}

example_fun(list(mtcars, iris))

try(example_fun(list(letters, 1:10)))

try(example_fun(c(TRUE, FALSE)))
}
\author{
Thomas Neitmann
}
\keyword{assertion}
