% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_extreme_event.R
\name{event_joined}
\alias{event_joined}
\title{Create a \code{event_joined} Object}
\usage{
event_joined(
  dataset_name = NULL,
  condition,
  order = NULL,
  join_vars,
  join_type,
  first_cond = NULL,
  set_values_to = NULL,
  keep_source_vars = NULL,
  description = NULL
)
}
\arguments{
\item{dataset_name}{Dataset name of the dataset to be used as input for the
event. The name refers to the dataset specified for \code{source_datasets} in
\code{derive_extreme_event()}. If the argument is not specified, the input
dataset (\code{dataset}) of \code{derive_extreme_event()} is used.}

\item{condition}{An unquoted condition for selecting the observations, which
will contribute to the extreme event.

\emph{Permitted Values}: an unquoted condition}

\item{order}{If specified, the specified variables or expressions are used to
select the first observation.

\emph{Permitted Values}: list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))} or \code{NULL}}

\item{join_vars}{Variables to keep from joined dataset

The variables needed from the other observations should be specified for
this parameter. The specified variables are added to the joined dataset
with suffix ".join". For example to select all observations with \code{AVALC == "Y"} and \code{AVALC == "Y"} for at least one subsequent visit \code{join_vars = exprs(AVALC, AVISITN)} and \code{filter = AVALC == "Y" & AVALC.join == "Y" & AVISITN < AVISITN.join} could be specified.

The \verb{*.join} variables are not included in the output dataset.}

\item{join_type}{Observations to keep after joining

The argument determines which of the joined observations are kept with
respect to the original observation. For example, if \code{join_type = "after"} is specified all observations after the original observations are
kept.

\emph{Permitted Values:} \code{"before"}, \code{"after"}, \code{"all"}}

\item{first_cond}{Condition for selecting range of data

If this argument is specified, the other observations are restricted up to
the first observation where the specified condition is fulfilled. If the
condition is not fulfilled for any of the subsequent observations, all
observations are removed.}

\item{set_values_to}{A named list returned by \code{exprs()} defining the variables
to be set for the event, e.g. \code{exprs(PARAMCD = "WSP", PARAM  = "Worst Sleeping Problems")}. The values can be a symbol, a
character string, a numeric value, \code{NA} or an expression.}

\item{keep_source_vars}{Variables to keep from the source dataset

The specified variables are kept for the selected observations. The
variables specified for \code{by_vars} (of \code{derive_extreme_event()}) and created
by \code{set_values_to} are always kept.

\emph{Permitted Values}: A list of expressions where each element is
a symbol or a tidyselect expression, e.g., \code{exprs(VISIT, VISITNUM, starts_with("RS"))}.}

\item{description}{Description of the event

The description does not affect the derivations where the event is used. It
is intended for documentation only.}
}
\value{
An object of class \code{event_joined}
}
\description{
The \code{event_joined} object is used to define events as input for the
\code{derive_extreme_event()} function. This object should be used if the event
does not depend on a single observation of the source dataset but on multiple
observations. For example, if the event needs to be confirmed by a second
observation of the source dataset.

The events are selected by calling \code{filter_joined()}. See its documentation
for more details.
}
\seealso{
\code{\link[=derive_extreme_event]{derive_extreme_event()}}, \code{\link[=event]{event()}}

Source Objects: 
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_source}()},
\code{\link{event}()},
\code{\link{query}()},
\code{\link{records_source}()},
\code{\link{tte_source}()}
}
\concept{source_specifications}
\keyword{source_specifications}
