% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\name{displayRawData}
\alias{displayRawData}
\title{Display raw data in a comprehensive way}
\usage{
displayRawData(x, ncol = 4, col.wid = 4, address.len = 3, hex.upper = T)
}
\arguments{
\item{x}{A vector of class \code{raw} to be displayed.}

\item{ncol}{Number of columns of hexadecimal code to display.}

\item{col.wid}{Width of each column (in bytes) to display.}

\item{address.len}{Length of the hexadecimal address
(in number of hexadecimal digits) to display.}

\item{hex.upper}{\code{logical} value, to specify whether hexadecimals
should be displayed in uppercase (\code{TRUE}, default) or
lowercase (\code{FALSE}).}
}
\value{
The \code{character} string send to the sink is also
returned by the function.
}
\description{
Cat \code{raw} data to the sink in columns with ASCII code
}
\details{
As binary data is hard to decipher this function will
cat raw data as hexadecimal code in columns, together
with the relative (hexadecimal) address of the data and
an ASCII translation of the data. Hexadecimals are shown
in space separated columns for improved readability. Special
characters are replaced by dots in the ASCII representation.

Raw data is padded with zeros at the end to fill remaining
columns...
}
\examples{
## Display some raw random data:
displayRawData(as.raw(sample.int(100)))

## Display the full ASCII table:
displayRawData(as.raw(0:255))
}
\seealso{
Other raw.operations: 
\code{\link{amigaDateToRaw}()},
\code{\link{amigaIntToRaw}()},
\code{\link{rawToAmigaDate}()},
\code{\link{rawToAmigaInt}()},
\code{\link{rawToBitmap}()}
}
\author{
Pepijn de Vries
}
\concept{raw.operations}
