% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{adf.disk.name}
\alias{adf.disk.name}
\alias{adf.disk.name,amigaDisk-method}
\alias{adf.disk.name<-}
\alias{adf.disk.name<-,amigaDisk,character-method}
\title{Get or set the disk name of an amigaDisk object}
\usage{
\S4method{adf.disk.name}{amigaDisk}(x)

\S4method{adf.disk.name}{amigaDisk,character}(x) <- value
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object for which the disk
name needs to be obtained or changed.}

\item{value}{A \code{character} representation with which the
disk's name needs to be replaced. Disk name needs to be between
1 and 30 characters long and are not allowed to contain a colon
or forward slash.}
}
\value{
Returns A \code{character} representation of the disk's
name.
}
\description{
Get or set the disk name of an \code{\link{amigaDisk}} object.
}
\details{
DOS-formatted disks (\code{\link{is.amigaDOS}}) store their disk
name on the socalled root block of the disk. This method allows
you to obtain the disk's name or change it (when it is DOS-formatted).
}
\examples{
\dontrun{
data(adf.example)

## get the disk name:
adf.disk.name(adf.example)

## change it if you don't like it:
adf.disk.name(adf.example) <- "MyDisk"

## confirm that it has changed:
adf.disk.name(adf.example)
}
}
\author{
Pepijn de Vries
}
