% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_alias_matrix}
\alias{fp_alias_matrix}
\title{Build the alias matrix}
\usage{
fp_alias_matrix(...)
}
\arguments{
\item{...}{one or more formulas, or a single list of formulas, or a
fractional factorial plan.}
}
\value{
a square matrix: each cell is \code{0} if there is no alias, or an
integer representing the index of the generator that produced that alias
in the list of generators.
}
\description{
Given a list of formulas (defining relationships), this function returns
a matrix of all possible aliases.
}
\details{
It is also possible to pass a fractional factorial plan, in which case the
defining relationships will be extracted from it.
}
\examples{
# with formulas:
fp_alias_matrix(~A*B*C, ~B*C*D)

# with a fractional factorial plan:
fp_design_matrix(5) \%>\%
  fp_fraction(~A*B*C*D) \%>\%
  fp_fraction(~B*C*D*E) \%>\%
  fp_alias_matrix() \%>\%
  plot()
}
\seealso{
\code{\link[=fp_fraction]{fp_fraction()}}
}
