% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ada_robust.R
\name{do_ada_robust}
\alias{do_ada_robust}
\title{Run the whole robust archetypoid analysis with the robust Frobenius norm}
\usage{
do_ada_robust(subset, numArchoid, numRep, huge, prob, compare = FALSE,
              vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
              outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"),
              method = "adjbox")
}
\arguments{
\item{subset}{Data to obtain archetypes. In ADALARA this is a subset of the 
entire data frame.}

\item{numArchoid}{Number of archetypes/archetypoids.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} 
times.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{prob}{Probability with values in [0,1].}

\item{compare}{Boolean argument to compute the non-robust residual sum of squares 
to compare these results with the ones provided by \code{\link{do_ada}}.}

\item{vect_tol}{Vector the tolerance values. Default c(0.95, 0.9, 0.85).
Needed if \code{method='toler'}.}

\item{alpha}{Significance level. Default 0.05. Needed if \code{method='toler'}.}

\item{outl_degree}{Type of outlier to identify the degree of outlierness.
Default c("outl_strong", "outl_semi_strong", "outl_moderate").
Needed if \code{method='toler'}.}

\item{method}{Method to compute the outliers. Options allowed are 'adjbox' for
using adjusted boxplots for skewed distributions, and 'toler' for using
tolerance intervals.}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item rss_non_rob: If \code{compare=TRUE}, this is the residual sum of squares using
the non-robust Frobenius norm. Otherwise, NULL.
\item resid Vector of residuals.
\item outliers: Outliers.
}
}
\description{
This function executes the entire procedure involved in the robust archetypoid 
analysis. Firstly, the initial vector of archetypoids is obtained using the 
robust archetypal algorithm and finally, the optimal vector of robust archetypoids 
is returned.
}
\examples{
\dontrun{
library(Anthropometry)
data(mtcars)
#data <- as.matrix(mtcars)
data <- mtcars

k <- 3
numRep <- 2
huge <- 200

preproc <- preprocessing(data, stand = TRUE, percAccomm = 1)
set.seed(2018)
res_ada_rob <- do_ada_robust(preproc$data, k, numRep, huge, 0.8,
                             FALSE, method = "adjbox")
str(res_ada_rob)    

res_ada_rob1 <- do_ada_robust(preproc$data, k, numRep, huge, 0.8,
                             FALSE, vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
                             outl_degree = c("outl_strong", "outl_semi_strong", 
                                             "outl_moderate"),
                             method = "toler")
str(res_ada_rob1)  
}
                 
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2018, submitted,
\url{https://arxiv.org/abs/1810.00919}
}
\seealso{
\code{\link{stepArchetypesRawData_robust}}, \code{\link{archetypoids_robust}}
}
\author{
Guillermo Vinue, Irene Epifanio
}
