% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{solartime}
\alias{solartime}
\title{Transforms clock time to solar time anchored to sun rise and sunset times for a given location.}
\usage{
solartime(
  dat,
  lat,
  lon,
  tz,
  ...,
  tryFormats = c("\%Y-\%m-\%d \%H:\%M:\%OS", "\%Y/\%m/\%d \%H:\%M:\%OS",
    "\%Y:\%m:\%d \%H:\%M:\%OS", "\%Y-\%m-\%d \%H:\%M", "\%Y/\%m/\%d \%H:\%M",
    "\%Y:\%m:\%d \%H:\%M", "\%Y-\%m-\%d", "\%Y/\%m/\%d", "\%Y:\%m:\%d")
)
}
\arguments{
\item{dat}{A vector of character, POSIXct or POSIXlt date-time values.}

\item{lat, lon}{Single numeric values or numeric vectors the same length as \code{dat} giving site latitude and longitude in decimal format.}

\item{tz}{A single numeric value or numeric vector same length as \code{dat} giving time zone (see Details).}

\item{...}{arguments passed to as.POSIXlt}

\item{tryFormats}{formats to try when converting date from character, passed to as.POSIXlt}
}
\value{
A list with elements:

\code{input}: event input dates-times in POSIXlt format.

\code{clock}: radian clock time data.

\code{solar}: radian solar time data anchored to average sun rise and sun set times.
}
\description{
This is a wrapper for \code{transtime} that takes non-numeric date-time input together with latitude and longitude to calculate mean average sunrise and sunset times, which are then used to anchor the transformation using average anchoring.
}
\details{
Time zone \code{tz} should be expressed in numeric hours relative to UTC (GMT).
}
\examples{
data(BCItime)
subdat <- subset(BCItime, species=="ocelot")
times <- solartime(subdat$date, 9.156335, -79.847682, -5)
rawAct <- fitact(times$clock)
avgAct <- fitact(times$solar)
plot(rawAct)
plot(avgAct, add=TRUE, data="n", tline=list(col="cyan"))
}
\references{
Vazquez, C., Rowcliffe, J.M., Spoelstra, K. and Jansen, P.A. in press. Comparing diel activity patterns of wildlife across latitudes and seasons: time transformation using day length. Methods in Ecology and Evolution.
}
\seealso{
\code{\link{strptime}, \link{transtime}}
}
