% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pro_score_dppac.R
\name{compute_pro_score_dppac}
\alias{compute_pro_score_dppac}
\title{Provide score for each question of the D-PPAC}
\usage{
compute_pro_score_dppac(
  x,
  question = c("q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12"),
  language = c("en", "fr")
)
}
\arguments{
\item{x}{A character string that is the exact response to the considered question from the D-PPAC questionnaire.}

\item{question}{A character value to identify the question to be considered when providing the score.}

\item{language}{A character value for setting the language of the considered questionnaire.}
}
\value{
A numeric value.
}
\description{
This function provides a score (from 0 to 4) in relation to the response to a given question from the D-PPAC questionnaire.
}
\examples{
compute_pro_score_dppac(
    x = "Un petit peu (jusqu\u2019\u00e0 10 minutes au total)", 
    question = "q1",
    language = "fr"
    )
    
}
