% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_results_import.R
\name{search_results_import}
\alias{search_results_import}
\title{Import search results}
\usage{
search_results_import(
  path,
  revertReplacements = TRUE,
  sheetNameXLSX = "data",
  encodingCSV = "UTF-8",
  separatorCSV = ","
)
}
\arguments{
\item{path}{Character string; path to file from where data will be loaded.}

\item{revertReplacements}{Logical, when exporting search results from act, '=' at the beginning of lines are replaced by '.=", and in numbers the decimal separator '.' is replaced by a ",". If \code{TRUE}, this replacement will be reverted when importing search results.}

\item{sheetNameXLSX}{Character string, set the name of the excel sheet containing the data.}

\item{encodingCSV}{Character string; text encoding in the case of CVS files.}

\item{separatorCSV}{Character; single character that is used to separate the columns in CSV files.}
}
\value{
Search object.
}
\description{
Search results will be imported from an Excel '.xlsx' file or a comma separated values '.csv' file into a search object.
}
\examples{
library(act)

# Search
mysearch <- act::search_new(examplecorpus, pattern="yo")
nrow(mysearch@results)

# Create temporary file path
path <- tempfile(pattern = "searchresults", tmpdir = tempdir(),
    			 fileext = ".xlsx")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
	path <- tempfile(pattern = "searchresults",
 					 tmpdir = "PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
 					 fileext = ".xlsx")
}

# Save search results
act::search_results_export(s=mysearch, path=path)

# Do your coding of the search results somewhere outside of act
# ...

# Load search results
mysearch.import <- act::search_results_import(path=path)
nrow(mysearch.import@results)
}
