% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_tiers_new_table.R
\name{helper_tiers_new_table}
\alias{helper_tiers_new_table}
\title{Helper: Create a tier table}
\usage{
helper_tiers_new_table(tierNames, tierTypes = NULL, tierPositions = NULL)
}
\arguments{
\item{tierNames}{Vector of character strings; names of the tiers.}

\item{tierTypes}{Vector of character strings; types of the tiers. Allowed values: "IntervalTier","TextTier". Needs to have the same length as 'tierNames'.}

\item{tierPositions}{Vector of integer values; Sort order of the tiers. Needs to have the same length as 'tierNames'.}
}
\value{
Data.frame
}
\description{
Creates a new tier table as necessary in \code{@tiers} of a transcript object.
}
\details{
NOTE: To actually modify the tiers in a transcript object or a corpus object corpus use the functions of the package.
This function is only a helper function and for people that like experiments.
}
\examples{
library(act)

# --- Create a tier table from scratch
tierTable <-act::helper_tiers_new_table(c("a","b","c", "d"), 
c("IntervalTier", "TextTier","IntervalTier","TextTier"))
tierTable
}
\seealso{
\link{helper_tiers_sort_table}, \link{helper_tiers_merge_tables}, \link{tiers_convert}, \link{tiers_rename}, \link{tiers_sort}
}
