% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snippets_printtranscripts_for_search.R
\name{snippets_printtranscripts_search}
\alias{snippets_printtranscripts_search}
\title{Create print transcripts for all search results}
\usage{
snippets_printtranscripts_search(
  x = NULL,
  s = NULL,
  collection = "collection",
  contextBeforeSec = 0,
  contextAfterSec = 0,
  outputFolder = ""
)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{collection}{Character string; name of the collection/search. Will be used to create a sub folder in the output folder.}

\item{contextBeforeSec}{Double; how much context before the search result will be included (in seconds).}

\item{contextAfterSec}{Double; how much context after the search result will be included (in seconds).}

\item{outputFolder}{Character string; if set to "", the print transcripts will only be inserted in s@results; if the path to a existing folder is given transcripts will be saved in *.txt format.}
}
\value{
returns the search results with snippets inserted into a new column
}
\description{
Create print transcripts for all search results
}
\examples{
library(act)

# Search
mysearch <- act::search_new(examplecorpus, pattern="yo")

# Create print transcript snippets for all search results
test <- act::snippets_printtranscripts_search (x=examplecorpus,
                                                   s=mysearch)

# Display all transcript snippets on screen
cat(stringr::str_c(test$transcript, sep="\n", collapse = "\n"))

# Create print transcript snippets including 1 sec before and 5 sec after
test <- act::snippets_printtranscripts_search (x=examplecorpus,
                                                   s=mysearch,
                                                   contextBeforeSec=1,
                                                   contextAfterSec=5)

# Display all transcript snippets on screen
cat(stringr::str_c(test$transcript, sep="\n", collapse = "\n"))

}
