% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_examplecorpus.R
\docType{data}
\name{examplecorpus}
\alias{examplecorpus}
\title{Example corpus for the act package}
\format{
An object of class \code{"corpus"}
}
\source{
* GAT: Ehmer, Oliver/Satti, Luis Ignacio/Martinez, Angelita/Pfaender, Stefan (2019): Un sistema para transcribir el habla en la interaccion: GAT 2.0 Gespraechsforschung - Online-Zeitschrift zur verbalen Interaktion (www.gespraechsforschung-ozs.de) 20, 64-114. http://www.gespraechsforschung-online.de/2019.html
 * SYNC:	Ehmer, Oliver (2020, in press): Synchronization in demonstrations. Multimodal practices for instructing body knowledge. Linguistics Vanguard. https://www.degruyter.com/view/journals/lingvan/lingvan-overview.xml
}
\usage{
data(examplecorpus)
}
\description{
Example corpus with data loaded from the example annotations files that come with the package
}
\details{
You can download the corresponding media files from www.oliverehmer.de in the section "Digital Humanities".
Alternatively you can use the download commands in the example section.
}
\examples{
library(act)

# Summary of the data in the corpus
examplecorpus

# Summary of the data in th second transcripts in the corpus
examplecorpus@transcripts[[2]]

\dontrun{
# Download example corpus with media files
destinationpath <- "/EXISTING_FOLDERON_YOUR_COMPUTER/examplecorpus"
temp <- tempfile()
download.file(options()$act.examplecorpusURL, temp)
unzip(zipfile=temp, exdir=destinationpath)
}
}
\seealso{
, \link{corpus_new}, \link{corpus_load}
}
\keyword{datasets}
