% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/acme_table.R
\name{acme.table}
\alias{acme.table}
\title{Posterior Summary of Mortality}
\usage{
acme.table(C = 0, Rstar = 0.2496, T = 0.174, gam = c(0.5, 0.9), I = 7,
  Mmax = 200, xi = 1/2, lam = 0)
}
\arguments{
\item{C}{Observed mortality count. Non-negative integer or vector.}

\item{Rstar}{ACME inverse-inflation factor R*, reported by acme.summary()
as "Rstar."}

\item{T}{The first term in recursive calculation of Rstar, from acme.summary.}

\item{gam}{Values for highest posterior density credible interval.}

\item{I}{Interval length, days.}

\item{Mmax}{Maximimum value for which posterior probability is calculated.}

\item{xi}{First parameter of gamma prior. Default is 1/2 for Objective prior.}

\item{lam}{Second parameter of gamma prior. Default is 0 for Objective prior.}
}
\value{
\code{acme.table} returns a table which includes ACME
estimate (M_hat), posterior mean, and highest posterior credible intervals for probabilities
as specified by the parameter gam.
}
\description{
Calculates and summarizes the posterior distribution of mortality count.
}
\details{
Assuming a Gamma(xi, lam) on the average daily mortality rate m, this model
treats the mortality M for the current period as Poisson-distributed with
mean m*I. The carcass count C will include "new" carcasses with a Bi(M,T)
distribution as well as "old" carcasses (if bt > 0). For derivation of
resulting conditional pdf see Wolpert (2015).

This function calls \code{acme.post} but suppresses plotting.
}
\examples{
acme.table(C=0:5,Rstar = 0.2496, T = 0.174)
}

