% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{from_validator}
\alias{from_validator}
\title{Use a validate::validator object to test a group}
\usage{
from_validator(v, ...)
}
\arguments{
\item{v}{\code{[validator]} a validator object from the
\code{validate} package.}

\item{...}{options passed to \code{validate::confront}}
}
\value{
a function that accepts a data fram and returns \code{TRUE}
        when the data passes all checks in \code{v} and otherwise
        \code{FALSE}.
}
\description{
Returns \code{TRUE} when the data passes all checks defined in the
\code{validator} object, otherwise \code{FALSE}.
}
\note{
Requires the \code{validate} package to be installed.
}
\examples{

if (requireNamespace("validate", quitetly=TRUE)){
 v <- validator(height >= 0, weight >= 0)
 f <- from_validator(v)
 f(women)  # TRUE (all heights and weights are nonnegative)
}


}
\references{
Mark P. J. van der Loo, Edwin de Jonge (2021). Data Validation
Infrastructure for R. Journal of Statistical Software, 97(10), 1-31.
doi:10.18637/jss.v097.i10
}
