% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalFunctions.R
\name{predict.ordASDA}
\alias{predict.ordASDA}
\title{Predict method for ordinal sparse discriminant analysis}
\usage{
\method{predict}{ordASDA}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Object of class ordASDA. This object is returned from the function \code{\link{ordASDA}}.}

\item{newdata}{A matrix of new observations to classify.}

\item{...}{Arguments passed to \code{\link[MASS]{predict.lda}}.}
}
\value{
A vector of predictions.
}
\description{
Predicted values based on fit from the function \code{\link{ordASDA}}. This
function is used to classify new observations based on their explanatory variables/features.
There is no need to normalize the data, the data is normalized based on the normalization
data from the ordASDA object.
}
\examples{
    set.seed(123)

    # You can play around with these values to generate some 2D data to test one
    numClasses <- 5
    sigma <- matrix(c(1,-0.2,-0.2,1),2,2)
    mu <- c(0,0)
    numObsPerClass <- 5

    # Generate the data, can access with train$X and train$Y
    train <- accSDA::genDat(numClasses,numObsPerClass,mu,sigma)
    test <- accSDA::genDat(numClasses,numObsPerClass*2,mu,sigma)

    # Visualize it, only using the first variable gives very good separation
    plot(train$X[,1],train$X[,2],col = factor(train$Y),asp=1,main="Training Data")

    # Train the ordinal based model
    res <- accSDA::ordASDA(train$X,train$Y,s=2,h=1, gam=1e-6, lam=1e-3)
    vals <- predict(object = res,newdata = test$X) # Takes a while to run ~ 10 seconds
    sum(vals==test$Y)/length(vals) # Get accuracy on test set
    #plot(test$X[,1],test$X[,2],col = factor(test$Y),asp=1,
    #      main="Test Data with correct labels")
    #plot(test$X[,1],test$X[,2],col = factor(vals),asp=1,
    #     main="Test Data with predictions from ordinal classifier")
}
\seealso{
\code{\link{ordASDA}}
}
