% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvec.R
\name{pvec}
\alias{pvec}
\title{Verbose, parallel, and safe map-like}
\usage{
pvec(.x, .f, ..., .cores = get_cores(), .progress = TRUE,
  .flatten = FALSE, .options = future_options())
}
\arguments{
\item{.x}{A list or atomic vector}

\item{.f}{A function, formula, or atomic vector (see \code{\link[purrr:map]{purrr::map()}})}

\item{...}{Other parameters passed on to \code{.f}}

\item{.cores}{Number of cores to use when multiprocessing}

\item{.progress}{Whether or not to display progress}

\item{.flatten}{If \code{TRUE}, the errors are filtered from the output,
and the returned object is flattened (a vector, a list, or a tibble)}

\item{.options}{Options passed on to \code{\link[furrr:future_map]{furrr::future_map()}}
(\code{\link[furrr:future_options]{furrr::future_options()}} by default)}
}
\value{
A tibble with 3 columns: input, return, and output
}
\description{
Using the same argument notation as \code{\link[purrr:map]{purrr::map()}}, this function
iterates over a list of inputs \code{.x}, applying \code{.f} to each element. It
returns a tibble with the id, whether the function returned an error
and the output.
}
\seealso{
\code{\link[purrr:map]{purrr::map()}}, \code{\link[furrr:future_map]{furrr::future_map()}}, \code{\link[furrr:future_options]{furrr::future_options()}}
}
