% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_utils.R
\name{set_covariates}
\alias{set_covariates}
\title{Set the covariates of an aba model.}
\usage{
set_covariates(object, ...)
}
\arguments{
\item{object}{an aba model. The model for which you want to set covariates.}

\item{...}{strings or variables. This comma-separated collection of values
will become the single set of covariates. If you supply actual variables,
then the data of the aba model should already be set.}
}
\value{
An aba model with covariates set.
}
\description{
Covariates are the independent variables which you want to always be included
in your statistical models - regardless of the groups, outcomes, or
predictors. Only one set of covariates can be supplied. If you want to test
multiple sets of covariates, then you should specify them as predictors or you
should create a new, separate model. This function supports both string
inputs and actual variables. The inputs should be separated
by a comma, where all variables together is the single covariate set.
}
\examples{
data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# set with variables
model <- aba_model() \%>\%
  set_data(data) \%>\%
  set_covariates(AGE, GENDER, EDUCATION)

# supply strings - data does not need to be set first here. But it will
# result in an error if these variables do not éxist in the eventual data.
model <- aba_model() \%>\%
  set_covariates('AGE', 'GENDER', 'EDUCATION')

}
