% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aSPUs.R
\name{aSPUs}
\alias{aSPUs}
\title{Sum of Powered Score (SPUs) tests and adaptive SPU (aSPUs) test with GWAS summary statistics.}
\usage{
aSPUs(Zs, corrSNP, pow = c(1, 2, 4, 8, Inf), n.perm = 1000, Ps = FALSE)
}
\arguments{
\item{Zs}{Z-scores for each SNPs. It could be P-values if the Ps option is TRUE.}

\item{corrSNP}{Correaltion matirx of SNPs. Estimated from the reference population.}

\item{pow}{power used in SPU test. A vector of the powers.}

\item{n.perm}{number of permutations or bootstraps.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}
}
\value{
A list object, Ts : test statistics for the SPU tests (in the order of the specified pow) and finally for the aSPU test.
        pvs : p-values for the SPU and aSPU tests.
}
\description{
It gives p-values of the SPUs tests and aSPUs test with GWAS summary statistics.
}
\examples{
data(kegg9)
## example analysis using aSPUM test.
g <- kegg9$gene.info[1,1]  #  SOAT1
## Take snps mapped on gene "SOAT1" from the information of gene.info and snp.info.
snps <- which( ( kegg9$snp.info[,2] == kegg9$gene.info[kegg9$gene.info[,1] == g, 2] ) &
                 (kegg9$snp.info[,3] > kegg9$gene.info[kegg9$gene.info[,1] == g, 3] ) &
                 (kegg9$snp.info[,3] < kegg9$gene.info[kegg9$gene.info[,1] == g, 4] )  )
## Take subsets
newP <- kegg9$nP[snps] ;
ldsub <- kegg9$ldmatrix[snps, snps];
## Get p-value for gene SOAT1. Read vignette for details.
out <- aSPUs(newP, corrSNP=ldsub , pow=c(1,2,4,8, Inf), n.perm=100, Ps=TRUE)

out$Ts
# This is a vector of Test Statistics for SPUM and aSPUM tests.
# SPU1 to SPUInf corresponds with the option pow=c(1:8, Inf)
# They are SPU test statistics.
# The last element aSPUM is minimum of them, aSPUM statistic.

out$pvs
# This is a vector of p-values for SPUM and aSPUM tests.
# SPUM1 to SPUMInf corresponds with the option pow=c(1:8, Inf)
# They are p-values for corresponding SPUM tests.
# The last element is p-value of aSPUM test.
}
\author{
Il-Youp Kwak and Wei Pan
}
\references{
Wei Pan, Junghi Kim, Yiwei Zhang, Xiaotong Shen and Peng Wei (2014)
A powerful and adaptive association test for rare variants,
Genetics, 197(4), 1081-95

Junghi Kim, Jeffrey R Wozniak, Bryon A Mueller, Xiaotong Shen and Wei Pan (2014) Comparison of statistical tests for group differences in brain functional networks, NeuroImage, 1;101:681-694
}
\seealso{
\code{\link{aSPUw}} \code{\link{aSPU}}
}

