% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_squares.R
\name{canvas_squares}
\alias{canvas_squares}
\title{Paint Random Squares on a Canvas}
\usage{
canvas_squares(colors, background = '#000000', cuts = 50, ratio = 1.618,
               width = 200, height = 200, noise = FALSE)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the borders of the squares.}

\item{cuts}{a positive integer specifying the number of cuts to make.}

\item{ratio}{a value specifying the \code{1:1} ratio for each cut.}

\item{width}{a positive integer specifying the width of the artwork in pixels.}

\item{height}{a positive integer specifying the height of the artwork in pixels.}

\item{noise}{logical. Whether to add k-nn noise to the artwork. Caution, adding noise increases computation time significantly in large dimensions.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints random squares. It works by repeatedly cutting into the canvas at random locations and coloring the area that these cuts create.
}
\examples{
\donttest{
set.seed(14)
palette <- colorPalette('random', n = 4)
canvas_squares(colors = palette)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
