% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_turmite.R
\name{canvas_turmite}
\alias{canvas_turmite}
\title{Paint a Turmite on a Canvas}
\usage{
canvas_turmite(color, background = '#fafafa', p = 0.5, iterations = 1e7, 
               width = 1500, height = 1500)
}
\arguments{
\item{color}{a character specifying the color used for the turmite.}

\item{background}{a character specifying the color used for the background.}

\item{p}{the probability of a state switch within the turmite.}

\item{iterations}{the number of iterations of the turmite.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints a turmite. A turmite is a Turing machine which has an orientation in addition to a current state and a "tape" that consists of a two-dimensional grid of cells. The algorithm is simple: 1) turn on the spot (left, right, up, down) 2) change the color of the square 3) move forward one square.
}
\examples{
\donttest{
set.seed(1)
canvas_turmite(color = "#000000", background = "#fafafa")
}

}
\references{
\url{https://en.wikipedia.org/wiki/Turmite}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
