% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Happy.R
\name{Happy}
\alias{Happy}
\alias{A007770}
\title{Happy numbers}
\usage{
Happy(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A007770}{A007770}, a \emph{Happy} number is defined by the process that starts from
arbitrary positive integer and replaces the number by the sum of the squares of each digit until the number is 1.
First 6 Happy numbers are 1, 7, 10, 13, 19, 23.
}
\examples{
## generate first 30 happy numbers
first30 = Happy(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
