% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{data_channel_request}
\alias{data_channel_request}
\title{Channel Data Requests - YouTube Data API}
\usage{
data_channel_request(
  part = NULL,
  categoryId = NULL,
  forUsername = NULL,
  hl = NULL,
  id = NULL,
  managedByMe = NULL,
  maxResults = 5,
  mine = NULL,
  onBehalfOfContentOwner = NULL,
  pageToken = NULL,
  token = getOption("YouTube_Token")
)
}
\arguments{
\item{part}{Required. String.}

\item{categoryId}{String.}

\item{forUsername}{String.}

\item{hl}{String.}

\item{id}{String.}

\item{managedByMe}{String.}

\item{maxResults}{Integer.}

\item{mine}{String.}

\item{onBehalfOfContentOwner}{String.}

\item{pageToken}{String.}

\item{token}{Required.}
}
\value{
data.frame
}
\description{
This is a function to make API calls to the YouTube Data API for channel specific data.
While it can be called directly, it is primarily intended to help get lists of videos within
a channel. For more in-depth use of the Data API, please refer to \code{tuber}. For
more details on the following arguments, please refer to
\url{https://developers.google.com/youtube/v3/docs/channels/list}
}
\examples{
\dontrun{
data_channel_request(part = "contentDetails",
                     mine = "true")
}
}
