% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Interface.R
\name{getInterface}
\alias{evaluatorNumber}
\alias{evaluatorTable}
\alias{getInterface}
\alias{rmInterface}
\title{Get or start an evaluator for an interface}
\usage{
getInterface(Class, ..., .makeNew = NA, .select = NULL)

rmInterface(evaluator)

evaluatorNumber(evaluator, add = length(id) > 0)
}
\arguments{
\item{Class}{the name of the interface class for this evaluator; by default, the class of the
current evaluator. Can also be the class definition object.}

\item{...}{arguments, if any, are passed to the generator for the evaluator}

\item{.makeNew}{can be used to force or prevent starting a new evaluator, if passed as
a logical value.  Can also be passed as a function that tests the suitability of a
current evaluator, returning TRUE if this one won't do, and a new one should be
generated instead (consistent with the ... arguments, presumably).

The default is NA, meaning that an existing evaluator is OK, but one should be generated
if none exists.  In contrast, FALSE means to return NULL if no matching evaluator exists.}

\item{.select}{Can be supplied as a function of one argument, which will be called for
each evaluator of this class and which should return \code{TRUE}/\code{FALSE} according to
whether the evaluator should be accepted.  Allows applications to select, for example, a
particular evaluator corresponding to a known connection.}

\item{evaluator}{any evaluator object.}

\item{add}{if this evaluator is not in the table, add it.  Default \code{TRUE}.}
}
\value{
\code{getInterface()} returns an  interface evaluator for this class, starting one if none exists.
}
\description{
Utility functions to manage a table of evaluators, indexed by the evaluator class, typically
one class per server language. All are typically hidden by functions or methods for the particular
class. \code{rmInterface} and \code{evaluatorNumber} are used by methods and exported so that
subclasses of interface evaluators will have access to them.
}
\details{
Specific language interface packages usually supply a convenience function equivalent
to calling \code{getInterface()} for their class; e.g., \code{RPython()} in \code{'XRPython'}

If no \code{Class} is given, the current (i.e., last active) evaluator is returned
}
\section{Functions}{
\itemize{
\item \code{rmInterface}: Remove the specified  evaluator from the table of available interfaces.

\item \code{evaluatorNumber}: Return the sequential number for this evalutor; used in \code{ProxyName()} method.
If not there: if \code{add}, add the evaluator to the table; else return \code{NA}.
}}
\examples{
## the current evaluator, or NULL if none exists
getInterface()
## this will always be NULL, because no evaluator has this class
getInterface("Interface", .makeNew = FALSE)
}

