% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Interface.R
\docType{class}
\name{InterfaceCondition-class}
\alias{InterfaceCondition-class}
\alias{InterfaceError-class}
\alias{InterfaceWarning-class}
\title{Classes of objects representing errors or other conditions in a server language}
\description{
Errors and warnings generated in evaluating an expression in the server language will
be returned to R as objects from one of these classes.
The interface evaluator will normally throw an error for \code{"InterfaceError"} and
issue a warning for \code{"InterfaceWarning"}.
}
\section{Slots}{

\describe{
\item{\code{message}}{The character string message from the server language evaluator.}

\item{\code{value}}{In the case of a warning, the object to return after issuing the condition.}

\item{\code{expr}}{The expression sent to the server language that produced the condition.}

\item{\code{evaluator}}{The interface evaluator object receiving the condition.}
}}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 12, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}

