% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ximages.R
\name{ximages}
\alias{ximages}
\title{ximages}
\usage{
ximages(locations, variables, statistics, layersdepths, localPath = tempdir())
}
\arguments{
\item{locations}{A \code{data.frame} object with locations data.}

\item{variables}{A \code{vector} with soil variable codes. There are 13
variables in the POLARIS database: \code{ph} (soil water pH), \code{om} (organic
matter), \code{clay}, \code{sand}, \code{silt}, \code{bd} (bulk density), \code{hb} (bubbling
pressure), \code{n} (pore size distribution), \code{alpha} (scale parameter
inversely proportional to mean pore diameter), \code{ksat} (saturated
hydraulic conductivity), \code{lambda} (pore size distribution index),
\code{theta_r} (residual soil water content), and \code{theta_s} (saturated
soil water content).}

\item{statistics}{A \code{vector} with the distribution summary options.
There are five options of summary statistics: \code{mean}, \code{mode}, median
(\code{p50}), five (\code{p5}) and 95 (\code{p95}) percentiles.}

\item{layersdepths}{A \code{vector} with the soil depth codes. There are six
options of soil depth layers: \verb{0_5}, \verb{5_15}, \verb{15_30}, \verb{30_60}, \verb{60_100},
and \verb{100_200} cm.}

\item{localPath}{Path to store the images. Default: \code{tempdir()}}
}
\value{
This function simply downloads the images from the POLARIS
database, according to the user request. Images are saved under a
new directory, called \code{POLARISOut}, within the \code{localPath}.
}
\description{
Downloading images from the POLARIS database.
}
\details{
For details on units check package repository.
}
\examples{
\dontrun{
df_test <- exkansas
df_ximages <- ximages(locations = df_test,
                      variables = c('clay'),
                      statistics = c('mean'),
                      layersdepths = c('0_5'))
}
}
\seealso{
\code{\link[XPolaris]{xplot}},\code{\link[XPolaris]{xsoil}}
}
