/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataType;
import java.util.ArrayList;

public class DataFrame {
    protected ArrayList<String> columnNames = new ArrayList();
    protected ArrayList<Column> columns = new ArrayList();

    public int columns() {
        return this.columns.size();
    }

    public int rows() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.columns.get(0).size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public boolean hasColumnHeader() {
        boolean hasHeader = false;
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (this.columnNames.get(i) == null) continue;
            hasHeader = true;
            break;
        }
        return hasHeader;
    }

    public void addColumn(String name, Column column) {
        if (!this.isEmpty() && column.size() != this.rows()) {
            throw new IllegalArgumentException("Length of specified column does not match length of existing columns in the DataFrame!");
        }
        this.columnNames.add(name);
        this.columns.add(column);
    }

    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    public DataType getColumnType(int index) {
        return this.columns.get(index).getDataType();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public ArrayList<String> getColumnNames() {
        return this.columnNames;
    }

    public ArrayList<DataType> getColumnTypes() {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(this.columns.size());
        for (Column c : this.columns) {
            dataTypes.add(c.getDataType());
        }
        return dataTypes;
    }
}

