/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.io.File;
import java.lang.reflect.Array;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class App {
    public static void main(String[] args) throws Exception {
        Workbook wb = WorkbookFactory.create((File)new File("/home/mstuder/Downloads/minimal.xlsx"));
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        evaluator.clearAllCachedResultValues();
        Sheet sheet = wb.getSheet("Sheet1");
        Cell cell = sheet.getRow(5).getCell(4);
        CellValue value = evaluator.evaluate(cell);
        System.out.println(value.getCellType() == 5);
        CellUtils.getErrorMessage(value.getErrorValue());
    }

    public static void printDataFrame(DataFrame df) {
        for (int i = 0; i < df.columns(); ++i) {
            System.out.println(df.getColumnName(i) + ":");
            Object data = df.getColumn(i).getData();
            boolean[] missing = df.getColumn(i).getMissing();
            int len = missing.length;
            for (int j = 0; j < len; ++j) {
                if (missing[j]) {
                    System.out.print("[NA]");
                } else {
                    System.out.print(Array.get(data, j));
                }
                System.out.print(" ");
            }
            System.out.println();
        }
    }
}

