/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.File;
import java.util.List;
import org.apache.poi.hssf.dev.BiffViewer;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.ss.formula.ptg.ExpPtg;
import org.apache.poi.ss.formula.ptg.FuncPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.Ptg;

public class FormulaViewer {
    private String file;
    private boolean list = false;

    public void run() throws Exception {
        List<Record> records = RecordFactory.createRecords(BiffViewer.getPOIFSInputStream(new File(this.file)));
        for (int k = 0; k < records.size(); ++k) {
            Record record = records.get(k);
            if (record.getSid() != 6) continue;
            if (this.list) {
                this.listFormula((FormulaRecord)record);
                continue;
            }
            this.parseFormulaRecord((FormulaRecord)record);
        }
    }

    private void listFormula(FormulaRecord record) {
        int numptgs;
        String sep = "~";
        Ptg[] tokens = record.getParsedExpression();
        Ptg token = tokens[(numptgs = tokens.length) - 1];
        String numArg = token instanceof FuncPtg ? String.valueOf(numptgs - 1) : String.valueOf(-1);
        StringBuffer buf = new StringBuffer();
        if (token instanceof ExpPtg) {
            return;
        }
        buf.append(((OperationPtg)token).toFormulaString());
        buf.append(sep);
        switch (token.getPtgClass()) {
            case 0: {
                buf.append("REF");
                break;
            }
            case 32: {
                buf.append("VALUE");
                break;
            }
            case 64: {
                buf.append("ARRAY");
            }
        }
        buf.append(sep);
        if (numptgs > 1) {
            token = tokens[numptgs - 2];
            switch (token.getPtgClass()) {
                case 0: {
                    buf.append("REF");
                    break;
                }
                case 32: {
                    buf.append("VALUE");
                    break;
                }
                case 64: {
                    buf.append("ARRAY");
                }
            }
        } else {
            buf.append("VALUE");
        }
        buf.append(sep);
        buf.append(numArg);
        System.out.println(buf.toString());
    }

    public void parseFormulaRecord(FormulaRecord record) {
        System.out.println("==============================");
        System.out.print("row = " + record.getRow());
        System.out.println(", col = " + record.getColumn());
        System.out.println("value = " + record.getValue());
        System.out.print("xf = " + record.getXFIndex());
        System.out.print(", number of ptgs = " + record.getParsedExpression().length);
        System.out.println(", options = " + record.getOptions());
        System.out.println("RPN List = " + this.formulaString(record));
        System.out.println("Formula text = " + FormulaViewer.composeFormula(record));
    }

    private String formulaString(FormulaRecord record) {
        StringBuffer buf = new StringBuffer();
        Ptg[] tokens = record.getParsedExpression();
        for (int i = 0; i < tokens.length; ++i) {
            Ptg token = tokens[i];
            buf.append(token.toFormulaString());
            switch (token.getPtgClass()) {
                case 0: {
                    buf.append("(R)");
                    break;
                }
                case 32: {
                    buf.append("(V)");
                    break;
                }
                case 64: {
                    buf.append("(A)");
                }
            }
            buf.append(' ');
        }
        return buf.toString();
    }

    private static String composeFormula(FormulaRecord record) {
        return HSSFFormulaParser.toFormulaString(null, record.getParsedExpression());
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public static void main(String[] args) {
        if (args == null || args.length > 2 || args[0].equals("--help")) {
            System.out.println("FormulaViewer .8 proof that the devil lies in the details (or just in BIFF8 files in general)");
            System.out.println("usage: Give me a big fat file name");
        } else if (args[0].equals("--listFunctions")) {
            try {
                FormulaViewer viewer = new FormulaViewer();
                viewer.setFile(args[1]);
                viewer.setList(true);
                viewer.run();
            }
            catch (Exception e) {
                System.out.println("Whoops!");
                e.printStackTrace();
            }
        } else {
            try {
                FormulaViewer viewer = new FormulaViewer();
                viewer.setFile(args[0]);
                viewer.run();
            }
            catch (Exception e) {
                System.out.println("Whoops!");
                e.printStackTrace();
            }
        }
    }
}

