/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import com.miraisolutions.xlconnect.data.DataType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.util.CellReference;

public abstract class CellUtils {
    public static boolean isCellValueOfType(CellValue cv, DataType type) {
        switch (cv.getCellType()) {
            case 4: {
                return DataType.Boolean.equals((Object)type);
            }
            case 0: {
                return DataType.Numeric.equals((Object)type) || DataType.DateTime.equals((Object)type) && DateUtil.isValidExcelDate((double)cv.getNumberValue());
            }
            case 1: {
                return DataType.String.equals((Object)type);
            }
        }
        return false;
    }

    public static String formatAsString(Cell cell) {
        return new CellReference(cell).formatAsString();
    }

    public static String getErrorMessage(FormulaError error) {
        switch (error) {
            case DIV0: {
                return "Division by 0";
            }
            case NA: {
                return "Value is not available";
            }
            case NAME: {
                return "No such name defined";
            }
            case NULL: {
                return "Two areas are required to intersect but do not";
            }
            case NUM: {
                return "Value outside of domain";
            }
            case REF: {
                return "Invalid cell reference";
            }
            case VALUE: {
                return "Incompatible type";
            }
        }
        return "Unknown error";
    }

    public static String getErrorMessage(byte errorCode) {
        return CellUtils.getErrorMessage(FormulaError.forInt((byte)errorCode));
    }
}

