% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xPolarDot.r
\name{xPolarDot}
\alias{xPolarDot}
\title{Function to visualise a data frame using a polar dotplot}
\usage{
xPolarDot(df, colormap = "blue-yellow-red", shape = 19, size = 2,
parallel = FALSE, font.family = "sans", signature = TRUE)
}
\arguments{
\item{df}{a data frame with two columns ('name' and 'value')}

\item{colormap}{either NULL or color names ('blue-yellow-red' by
default) for points according to the value column}

\item{shape}{an integer specifying point shape}

\item{size}{an integer specifying the point size. By default, it sets
to 2}

\item{parallel}{logical to indicate whether the label is parallel to
polar coordinate. By default, it sets FALSE}

\item{font.family}{the font family for texts}

\item{signature}{logical to indicate whether the signature is assigned
to the plot caption. By default, it sets TRUE showing which function is
used to draw this graph}
}
\value{
an object of class "ggplot"
}
\description{
\code{xPolarDot} is supposed to visualise a data frame using a polar
dotplot. It returns an object of class "ggplot".
}
\note{
none
}
\examples{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev/"

\dontrun{
# a) provide the seed nodes/genes with the weight info
## load ImmunoBase
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase',
RData.location=RData.location)
## get genes within 500kb away from AS GWAS lead SNPs
seeds.genes <- ImmunoBase$AS$genes_variants
## seeds weighted according to distance away from lead SNPs
data <- 1- seeds.genes/500000

# b) prepare a data frame
df <- data.frame(name=names(data), value=data, stringsAsFactors=FALSE)

# c) do correlation
gp <- xPolarDot(df[1:50,])
gp
}
}
\seealso{
\code{\link{xPolarDot}}
}
