% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-WoodburyMatrix.R, R/is-symmetric.R,
%   R/matrix-ops.R
\docType{class}
\name{WoodburyMatrix-class}
\alias{WoodburyMatrix-class}
\alias{GWoodburyMatrix-class}
\alias{SWoodburyMatrix-class}
\alias{isSymmetric,GWoodburyMatrix-method}
\alias{isSymmetric,SWoodburyMatrix-method}
\alias{\%*\%,GWoodburyMatrix,ANY-method}
\alias{\%*\%,SWoodburyMatrix,ANY-method}
\alias{t,GWoodburyMatrix-method}
\alias{t,SWoodburyMatrix-method}
\title{Virtual class for Woodbury identity matrices}
\usage{
\S4method{isSymmetric}{GWoodburyMatrix}(object)

\S4method{isSymmetric}{SWoodburyMatrix}(object)

\S4method{\%*\%}{GWoodburyMatrix,ANY}(x, y)

\S4method{\%*\%}{SWoodburyMatrix,ANY}(x, y)

\S4method{t}{GWoodburyMatrix}(x)

\S4method{t}{SWoodburyMatrix}(x)
}
\arguments{
\item{object}{\code{WoodburyMatrix} object}

\item{x}{\code{WoodburyMatrix} object}

\item{y}{Matrix or vector}
}
\description{
The \code{WoodburyMatrix} is a virtual class, contained by both
\code{GWoodburyMatrix} (for general matrices) and \code{SWoodburyMatrix}
(for symmetric matrices). See \link{WoodburyMatrix} for construction
of these classes. The methods available for these classes are described
below; see also the \link{solve} methods. This class is itself a subclass of
\code{\linkS4class{Matrix}}, so basic matrix methods like \code{nrow},
\code{ncol}, \code{dim} and so on also work.
}
\section{Functions}{
\itemize{
\item \code{GWoodburyMatrix-class}: Sub-class representing a generic matrix.

\item \code{SWoodburyMatrix-class}: Sub-class representing a symmetric matrix.
Also subclasses \linkS4class{symmetricMatrix}.

\item \code{isSymmetric,GWoodburyMatrix-method}: Check for symmetry of matrix; always returns
\code{FALSE}.

\item \code{isSymmetric,SWoodburyMatrix-method}: Check for symmetry of matrix; always returns
\code{TRUE}.

\item \code{\%*\%,GWoodburyMatrix,ANY-method}: Matrix multiplication (generally fast and

\item \code{\%*\%,SWoodburyMatrix,ANY-method}: Matrix multiplication (generally fast and

\item \code{t,GWoodburyMatrix-method}: Return the transpose of the matrix as
another GWoodburyMatrix.

\item \code{t,SWoodburyMatrix-method}: Does nothing, just returns \code{x}.
}}

\section{Slots}{

\describe{
\item{\code{A}}{n x n subclass of \code{\linkS4class{Matrix}}
(\code{GWoodburyMatrix}) or \code{\linkS4class{symmetricMatrix}}
(\code{SWoodburyMatrix}).}

\item{\code{B}}{p x p subclass of \code{\linkS4class{Matrix}}
(\code{GWoodburyMatrix}) or \code{\linkS4class{symmetricMatrix}}
(\code{SWoodburyMatrix}).}

\item{\code{U}}{n x p subclass of \code{\linkS4class{Matrix}} (only for}

\item{\code{V}}{p x m subclass of \code{\linkS4class{Matrix}} (only for}

\item{\code{X}}{n x p subclass of \code{\linkS4class{Matrix}} (only for}

\item{\code{O}}{p x p subclass of \code{\linkS4class{Matrix}}}
}}

\seealso{
\link{WoodburyMatrix} for object construction, \linkS4class{Matrix}
(the parent of this class).
}
