% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/content.R
\name{random_page}
\alias{random_page}
\title{Retrieve the page content of a random MediaWiki page}
\usage{
random_page(language = NULL, project = NULL, domain = NULL,
  namespaces = NULL, as_wikitext = FALSE, clean_response = FALSE, ...)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{namespaces}{The namespaces to consider pages from. By default, pages from any namespace are
considered; alternately, a numeric vector of accepted namespaces (which are described
\href{https://www.mediawiki.org/wiki/Manual:Namespace#Built-in_namespaces}{here}) can be
provided, and only pages within those namespaces will be considered.}

\item{as_wikitext}{whether to retrieve the wikimarkup (TRUE) or the HTML (FALSE).
Set to FALSE by default.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
wiki_page retrieves the DOM of a particular MediaWiki page,
as a HTML blob inside a JSON object.
}
\examples{
#A page from Wikipedia
wp_content <- random_page("en","wikipedia")

#A page from the mainspace on Wikipedia
wp_article_content <- random_page("en","wikipedia", namespaces = 0)
}
\seealso{
\code{\link{page_content}} for retrieving the content of a specific page,
\code{\link{revision_diff}} for retrieving 'diffs' between revisions,
\code{\link{revision_content}} for retrieving the text of specified revisions.
}

