% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/categories.R
\name{pages_in_category}
\alias{pages_in_category}
\title{Retrieves a list of category members.}
\usage{
pages_in_category(language = NULL, project = NULL, domain = NULL,
  categories, properties = c("title", "ids", "sortkey", "sortkeyprefix",
  "type", "timestamp"), type = c("page", "subcat", "file"),
  clean_response = FALSE, ...)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{categories}{The names of the categories you want to gather information for.}

\item{properties}{The properties you want to gather for each member of the category.
Options are "title" (the name of the member, including namespace),
"id" (the unique numeric identifier of the member), "sortkey"
(the hexadecimal key used to sort that member within the category),
"sortkeyprefix" (the human-readable sort key), "type"
(whether the member is a page, a subcategory or a file) and
"timestamp" (when the member was added to the category)}

\item{type}{The type of member you're interested in returning;
options are any permutation of "page" (pages), "subcat" (subcategories) and "file" (files).}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET().}
}
\description{
wiki_catpages retrieves a list of pages, subcategories, files or all of the above
in a specified category (or series of specified categories)
}
\section{warnings}{

Because of the way MediaWiki stores this data, both "the category you asked for doesn't exist"
and "the category you asked for exists, but has no members" return in the same way.
}
\examples{
#Retrieve the pages in the "New Age" category on en.wiki
cats <- pages_in_category("en", "wikipedia", categories = "New Age")

#Retrieve the pages in the "New Age" category on rationalwiki.
rw_cats <- pages_in_category(domain = "rationalwiki.org", categories = "New Age")
}
\seealso{
\code{\link{categories_in_page}} for finding categories that a specified page is a member of.
}

