\name{wiki_diff}
\alias{wiki_diff}
\title{
Generates a "diff" between a pair of revisions
}
\description{
wiki_diff generates a diff between two revisions in a MediaWiki page. This is provided as an XML-parsable blob inside the returned JSON object.}
\usage{
  wiki_diff(con, revisions, properties = c("ids", "flags", "timestamp",
                                       "user", "userid", "size",
                                       "sha1", "contentmodel", "comment",
                                       "parsedcomment", "tags", "flagged"),
            direction = c("prev", "next", "cur"))
}
\arguments{
  \item{con}{
  A connector object, generated by \code{\link{wiki_con}}, that corresponds to the project you're trying to query.

}
  \item{revisions}{
  The revision IDs of each "start" revision.
}
  \item{properties}{
  Properties you're trying to retrieve about that revision, should you want to; options include "ids" (the revision ID of the revision...which is pointless), "flags" (whether the revision was 'minor' or not), "timestamp" (the timestamp of the revision, which can be parsed with \code{\link{wiki_timestamp}}), "user" (the username of the person who made that revision), "userid" (the userID of the person who made the revision), "size" (the size, in uncompressed bytes, of the revision), "sha1" (the SHA-1 hash of the revision text), "contentmodel" (the content model of the page, usually "wikitext"), "comment" (the revision summary associated with the revision), "parsedcomment" (the same, but parsed, generating HTML from any wikitext in that comment), "tags" (any tags associated with the revision) and "flagged" (the revision's status under Flagged Revisions)}
  \item{direction}{
  The direction you want the diff to go in from the revisionID you have provided. Options are "prev" (compare to the previous revision on that page), "next" (compare to the next revision on that page) and "cur" (compare to the current, extant version of the page).
}
}
\section{Warnings}{

MediaWiki's API is deliberately designed to restrict users' ability to make computing-intense requests - such as diff computation. As a result, the API only allows requests for one uncached diff in each request. If you ask for multiple diffs, some uncached and some cached, you will be provided with the cached diffs, one of the uncached diffs, and a warning.

If you're going to be asking for a lot of diffs, some of which may not be cached, it may be more sensible to retrieve the revisions themselves using \code{\link{wiki_revision}} and compute the diffs yourself.

}
\seealso{

  \code{\link{wiki_con}}
}
\examples{
  #Create connector
  ih_connector <- wiki_con(language = "en", project = "wikipedia")
  
  #Ask for a diff between revision 602943163 and the next-dated revision on that page,
  #also retrieving the username of the person who /made/ said revision
  ih_pagdiff <- wiki_diff(con = ih_connector, revision = 602943163,
                          properties = "user", direction = "next")
}