% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{query_wikidata}
\alias{query_wikidata}
\title{Send one or more SPARQL queries to WDQS}
\usage{
query_wikidata(sparql_query, format = "simple", ...)
}
\arguments{
\item{sparql_query}{SPARQL query (can be a vector of queries)}

\item{format}{"simple" uses CSV and returns pure character data frame, while
"smart" fetches JSON-formatted data and returns a data frame with datetime
columns converted to `POSIXct`}

\item{\\dots}{Additional parameters to supply to [httr::POST]}
}
\value{
A `tibble`. Note: QID values will be returned as QIDs, rather than URLs.
}
\description{
Makes a POST request to Wikidata Query Service SPARQL endpoint.
}
\section{Query limits}{

There is a hard query deadline configured which is set to 60 seconds. There
are also following limits:
- One client (user agent + IP) is allowed 60 seconds of processing time each
  60 seconds
- One client is allowed 30 error queries per minute
See [query limits section](https://www.mediawiki.org/wiki/Wikidata_Query_Service/User_Manual#Query_limits)
in the WDQS user manual for more information.
}

\examples{
# R's versions and release dates:
sparql_query <- 'SELECT DISTINCT
  ?softwareVersion ?publicationDate
  WHERE {
    BIND(wd:Q206904 AS ?R)
    ?R p:P348 [
      ps:P348 ?softwareVersion;
      pq:P577 ?publicationDate
    ] .
}'
query_wikidata(sparql_query)

\dontrun{
# "smart" format converts all datetime columns to POSIXct
query_wikidata(sparql_query, format = "smart")
}
}
