% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsvWienerDens.R
\name{dsvWienerPDF}
\alias{dsvWienerPDF}
\title{Partial derivative of the first-passage time probability density function of the diffusion model with respect to the inter-trial variability of the drift rate}
\usage{
dsvWienerPDF(
  t,
  response,
  a,
  v,
  w,
  t0 = 0,
  sv,
  sw = 0,
  st0 = 0,
  precision = NULL,
  K = NULL,
  n.threads = FALSE,
  n.evals = 6000
)
}
\arguments{
\item{t}{First-passage time. Numeric vector.}

\item{response}{Response boundary. Character vector with \code{"upper"} and \code{"lower"} as possible values. Alternatively a numeric vector with
\code{1}=lower and \code{2}=upper.}

\item{a}{Upper barrier. Numeric vector.}

\item{v}{Drift rate. Numeric vector.}

\item{w}{Relative starting point. Numeric vector.}

\item{t0}{Non-decision time. Numeric vector}

\item{sv}{Inter-trial variability of drift rate. Numeric vector. Standard deviation of a normal distribution \code{N(v, sv)}.}

\item{sw}{Inter-trial variability of relative starting point. Numeric vector. Range of uniform distribution \code{U(w-0.5*sw, w+0.5*sw)}.}

\item{st0}{Inter-trial variability of non-decision time. Numeric vector. Range of uniform distribution \code{U(t0, t0+st0)}.}

\item{precision}{Optional numeric value. Precision of the partial derivative. Numeric value. Default is \code{NULL}, which takes default value 1e-12.}

\item{K}{Optional numeric value. Number of iterations to calculate the infinite sums. Numeric value (integer). Default is \code{NULL}.
\itemize{
  \item \code{precision = NULL} and \code{K = NULL}: Default \code{precision = 1e-12} used to calculate internal K.
  \item \code{precision != NULL} and \code{K = NULL}: \code{precision} is used to calculate internal K,
  \item \code{precision = NULL} and \code{K != NULL}: \code{K} is used as internal K,
  \item \code{precision != NULL} and \code{K != NULL}: if internal K calculated through \code{precision} is smaller than \code{K}, \code{K} is used.
}
We recommend using either default (\code{precision = K = NULL}) or only \code{precision}.}

\item{n.threads}{Optional numerical or logical value. Number of threads to use. If not provided (or 1 or \code{FALSE}) parallelization is not used. If set to \code{TRUE} then all available threads are used.}

\item{n.evals}{Optional. Number of maximal function evaluations in the numeric integral. Default is \code{6000} and \code{0} implies no limit and the 
numeric integration goes on until the specified \code{precision} is guaranteed.}
}
\value{
A list of the class \code{Diffusion_deriv} containing
  \itemize{
    \item \code{deriv}: the derivatives of the PDF with respect to a,
    \item \code{call}: the function call,
    \item \code{err}: the absolute error.
  }
}
\description{
Calculates the partial derivative of the first-passage time probability density function of the diffusion model with respect to the inter-trial variability of the drift rate sv.
}
\examples{
dsvWienerPDF(t = 1.2, response = "upper", a = 1.1, v = 13, w = .6, sv = .2)
}
\references{
Hartmann, R., & Klauer, K. C. (2021). Partial derivatives for the first-passage time distribution in Wiener diffusion models. \emph{Journal of Mathematical Psychology, 103}, 102550. \doi{10.1016/j.jmp.2021.102550}
}
\author{
Raphael Hartmann
}
