% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_backnow.R
\name{run_backnow}
\alias{run_backnow}
\title{Run Back Calculation and Estimate Reproduction Numbers}
\usage{
run_backnow(
  input,
  sip,
  NB_maxdelay = as.integer(20),
  window_size = as.integer(7),
  ...
)
}
\arguments{
\item{input}{A 'lineList' data.frame from \code{create_linelist} or \code{convert_to_linelist}.}

\item{sip}{Vector of numeric values specifying the serial interval probabilities.}

\item{NB_maxdelay}{Integer, the maximum delay for the negative binomial distribution used in modeling.}

\item{window_size}{Integer, the number of days of the R(t) averaging window.}

\item{...}{Additional arguments passed to rstan::sampling()}
}
\value{
an object of class \code{backnow}
}
\description{
This function performs a back-calculation based on provided epidemic case count data,
estimating the time distribution of infections and reproduction numbers (r(t)).
It utilizes extensive input checks and parameter validation to ensure robust model execution.
}
\details{
The function ensures input data is of the correct class and processes it accordingly.
It handles different input classes by either converting \code{caseCounts} to \code{lineList} or
directly using \code{lineList}. The function stops with an error if the input doesn't meet expected standards.
It performs simulations to estimate both the back-calculation of initial infections and reproduction numbers
over time, while checking and adjusting for potential NA values and ensuring that all conditions for the
model parameters are met. Output includes estimates of initial infections and reproduction numbers along
with diagnostic statistics.
}
\examples{
\donttest{
data("sample_onset_dates")
data("sample_report_dates")
line_list <- create_linelist(sample_report_dates, sample_onset_dates)
sip <- si(14, 4.29, 1.18)
results <- run_backnow(
  line_list,
  sip = sip, chains = 1)
}
}
